﻿;*******************************************************************************
;	Title	簡易ログウィンドウライブラリ(AHKv2)
;	Author	NightWork
;	Ver		20251007
;
;-------------------------------------------------------------------------------
;	簡易ログシステム、背景透過ウィンドウ上にOSD表示する。
;	ファイルへの書き出し機能などはない。
;	※必要であれば関数の戻り値を保存すればよい。
;
;*******************************************************************************


;*******************************************************************************
; ログに追記する、初回呼び出し時はログウィンドウを作成する。
;*******************************************************************************
;===============================================================================
;	引数	log_text	追記文字列
;			newline		追記前に改行する行数、省略時は1。
;			hide		ログウィンドウの表示状態を変更する、省略時は前回の状態を保持する。
;						0:表示状態にする
;						1:非表示状態にする
;
;-------------------------------------------------------------------------------
;	返り値	ログ全内容
;
;===============================================================================
EzLog( log_text, newline:=1, hide:=-1) {
	;--------------------------------------------------
	;変数
	static GuiObj		:=	0
	static GuiCtrlObj	:=	0
	static log_data		:=	""

	;--------------------------------------------------
	;改行
	Loop newline
		log_data	.= Chr( 10)

	;ログ追記
	log_data	.= log_text

	;--------------------------------------------------
	;ウィンドウ初期化
	If ( !GuiObj)
	{
		gui_option		:=	"+AlwaysOnTop"
			. Chr( 32)	.	"-Border"
			. Chr( 32)	.	"+LastFound"
			. Chr( 32)	.	"+ToolWindow"
		GuiObj	:=	Gui( gui_option, "EzLog Window")
		GuiObj	.SetFont( "cLime s16 Bold")
		GuiObj	.BackColor	:= "0xFFFFFF"

		ctrl_option		:=	"xm"
			. Chr( 32)	.	"ym"
			. Chr( 32)	.	"w"		. ( A_ScreenWidth	- 50)
			. Chr( 32)	.	"h"		. ( A_ScreenHeight	- 50)
		GuiCtrlObj	:= GuiObj.Add( "Text",	ctrl_option)

		window_option	:=	"x0"
			. Chr( 32)	.	"y0"
			. Chr( 32)	.	"Hide"
		GuiObj	.Show( window_option)

		winreg_option	:=	"5-5"
			. Chr( 32)	.	"w"		. ( A_ScreenWidth	- 60)
			. Chr( 32)	.	"h"		. ( A_ScreenHeight	- 60)
		WinSetRegion( winreg_option)

		WinSetTransColor( "0xFFFFFF")

		If !( hide == 1)
			GuiObj.Show( "NA")
	}

	;--------------------------------------------------
	;表示更新
	GuiCtrlObj.Text	:= log_data

	;--------------------------------------------------
	;ウィンドウ表示状態制御
	If ((  hide == 1)
	&&	( 0x10000000 & WinGetStyle()))
		GuiObj.Hide()

	If ((  hide == 0)
	&& !( 0x10000000 & WinGetStyle()))
		GuiObj.Show( "NA")

	Return log_data
}
