﻿;*******************************************************************************
;	Title	優先度制御ライブラリ テストアプリ
;	Author	NightWork
;	Ver		20251006
;
;-------------------------------------------------------------------------------
;	自プロセスののCPU優先度、I/O優先度、メモリ優先度を操作するサンプル
;
;*******************************************************************************

;*******************************************************************************
; 起動
;*******************************************************************************
;===============================================================================
; 起動処理
;===============================================================================
	;---------------------------------------
	; 起動設定
	;---------------------------------------
	#Persistent
	#NoEnv
	#NoTrayIcon
	#SingleInstance Force
	SetWorkingDir,	%A_ScriptDir%

	;---------------------------------------
	; ソフトウェア情報定数
	;---------------------------------------
	APP_TILTE		:= "Priority Lib Test"
	APP_VER			:= "20251006"
	APP_WINDOWTITLE	:= APP_TILTE . " (Ver." . APP_VER . ")"

	;---------------------------------------
	; ウィンドウ構築・タイマースタート
	;---------------------------------------
	Gosub, WindowInit
	SetTimer, UpdateStates, 200

	Return


;===============================================================================
; 終了処理
;===============================================================================
GuiClose:
	ExitApp
	Return



;*******************************************************************************
; 関数ライブラリ読込
;*******************************************************************************
#Include Priority.ahk



;*******************************************************************************
; 設定ウィンドウ周り
;*******************************************************************************
;===============================================================================
; 設定ウィンドウ 初期化
;===============================================================================
WindowInit:
	;---------------------------------------
	; コントロールサイズ定数
	;---------------------------------------
	GUI_CONTROL_WIDTH			:= 150
	GUI_CONTROL_WIDTH_CLASS		:= 250
	GUI_CONTROL_WIDTH_LINE		:= 730
	GUI_CONTROL_HIGHT_LABEL		:= 20
	GUI_CONTROL_HIGHT_BUTTON	:= 25

	;--------------------------------------------------------------------------
	; プロセス優先度切替
	;-------------------------------------------------------------------------------
	Gui, Add, Text		, xm ym w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_LABEL%
						, プロセス優先度

	Gui ,Add ,Edit		, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% vCtrlEdit_Priority ReadOnly

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gPriorityUpdate vCtrlButton_Priority_24
						, リアルタイム

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gPriorityUpdate vCtrlButton_Priority_13
						, 高

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gPriorityUpdate vCtrlButton_Priority_10
						, 通常以上

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gPriorityUpdate vCtrlButton_Priority_8
						, 通常

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gPriorityUpdate vCtrlButton_Priority_6
						, 通常以下

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gPriorityUpdate vCtrlButton_Priority_4
						, 低

	;--------------------------------------------------------------------------
	; プロセスI/O優先度切替
	;--------------------------------------------------------------------------
	Gui, Add, Text		, x+10 ym w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_LABEL%
						, プロセスI/O優先度

	Gui ,Add ,Edit		, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% vCtrlEdit_IoPriority ReadOnly

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gIoPriorityUpdate vCtrlButton_IoPriority_2
						, 通常

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gIoPriorityUpdate vCtrlButton_IoPriority_1
						, 低

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gIoPriorityUpdate vCtrlButton_IoPriority_0
						, 特低

	;--------------------------------------------------------------------------
	; プロセスメモリ優先度切替
	;--------------------------------------------------------------------------
	Gui, Add, Text		, x+10 ym w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_LABEL%
						, プロセスメモリ優先度

	Gui ,Add ,Edit		, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% vCtrlEdit_MemoryPriority ReadOnly

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gMemoryPriorityUpdate vCtrlButton_MemoryPriority_5
						, 通常

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gMemoryPriorityUpdate vCtrlButton_MemoryPriority_4
						, 通常以下

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gMemoryPriorityUpdate vCtrlButton_MemoryPriority_3
						, 中

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gMemoryPriorityUpdate vCtrlButton_MemoryPriority_2
						, 低

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gMemoryPriorityUpdate vCtrlButton_MemoryPriority_1
						, 特低

	;--------------------------------------------------------------------------
	; バックグラウンド切替
	;--------------------------------------------------------------------------
	Gui, Add, Text		, x+10 ym w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_LABEL%
						, バックグラウンド切替

	Gui ,Add ,Text		, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON%	;ダミー

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gBackgroundModeBegin
						, バックグラウンド開始

	Gui ,Add ,Button	, xp+0 y+0 w%GUI_CONTROL_WIDTH% h%GUI_CONTROL_HIGHT_BUTTON% gBackgroundModeEnd
						, バックグラウンド終了

	;--------------------------------------------------------------------------
	; プロセス情報表示
	;--------------------------------------------------------------------------
	Gui, Add, Text		, xm ym+200 w%GUI_CONTROL_WIDTH_LINE% h%GUI_CONTROL_HIGHT_LABEL%
						, ---------------------------------------------------------------------------------------------------------------------------------

	Gui, Add, Text		, xm y+0 w200 h%GUI_CONTROL_HIGHT_LABEL%
						, アプリケーションウィンドウハンドル

	Gui, Add, Edit		, x+0 yp+0 w80 h%GUI_CONTROL_HIGHT_LABEL% ReadOnly vCtrlEdit_hWnd

	;---------------------------------------
	; 自身のhWndを取得
	;---------------------------------------
	Gui, +LastFound
	WinGet, app_hwnd, ID
	GuiControl	, Text	, CtrlEdit_hWnd	, %app_hwnd%

	;---------------------------------------
	; ウィンドウ表示
	;---------------------------------------
	Gui, Show,, %APP_WINDOWTITLE%

	Return



;*******************************************************************************
; 優先度制御
;*******************************************************************************
;-------------------------------------------------------------------------------
; CPU優先度設定
;-------------------------------------------------------------------------------
PriorityUpdate:
	StringReplace, priority_new, A_GuiControl, CtrlButton_Priority_
	SetProcessPriority( priority_new)
	Return


;-------------------------------------------------------------------------------
; I/O優先度設定
;-------------------------------------------------------------------------------
IoPriorityUpdate:
	StringReplace, io_priority_new, A_GuiControl, CtrlButton_IoPriority_
	SetProcessIoPriority( io_priority_new)
	Return


;-------------------------------------------------------------------------------
; メモリ優先度設定
;-------------------------------------------------------------------------------
MemoryPriorityUpdate:
	StringReplace, memory_priority_new, A_GuiControl, CtrlButton_MemoryPriority_
	SetProcessMemoryPriority( memory_priority_new)
	Return


;-------------------------------------------------------------------------------
; バックグラウンド開始
;-------------------------------------------------------------------------------
BackgroundModeBegin:
	ProcessModeBackgroundBegin()
	Return


;-------------------------------------------------------------------------------
; バックグラウンド終了
;-------------------------------------------------------------------------------
BackgroundModeEnd:
	ProcessModeBackgroundEnd()
	Return


;-------------------------------------------------------------------------------
; ステータス取得・更新
;-------------------------------------------------------------------------------
UpdateStates:
	priority	:= GetProcessPriority()
	GuiControl, Text, CtrlEdit_Priority, %priority%

	iopriority	:= GetProcessIoPriority()
	GuiControl, Text, CtrlEdit_IoPriority, %iopriority%

	memorypriority	:= GetProcessMemoryPriority()
	GuiControl, Text, CtrlEdit_MemoryPriority, %memorypriority%

	Return
