﻿;*******************************************************************************
;	Title	優先度制御ライブラリ(AHKv2) テストアプリ
;	Author	NightWork
;	Ver		20251006
;
;-------------------------------------------------------------------------------
;	自プロセスののCPU優先度、I/O優先度、メモリ優先度を操作するサンプル
;
;*******************************************************************************


;*******************************************************************************
; 起動
;*******************************************************************************
;===============================================================================
; 起動処理
;===============================================================================
	;---------------------------------------
	; 起動設定
	;---------------------------------------
	#Requires AutoHotkey v2.0
	#SingleInstance Force
	#NoTrayIcon
	Persistent

	;---------------------------------------
	; ソフトウェア情報定数
	;---------------------------------------
	APP_TILTE		:= "Priority v2 Lib Test"
	APP_VER			:= "20251006"
	APP_WINDOWTITLE	:= APP_TILTE . " (Ver." . APP_VER . ")"

	;---------------------------------------
	; ウィンドウ構築・タイマースタート
	;---------------------------------------
	hMainWindow	:=	MainWindowInit()
	SetTimer UpdateStates, 200

	Return


;===============================================================================
; 終了処理
;===============================================================================
Exit( GuiObj) {
	ExitApp
	Return
}



;*******************************************************************************
; 関数ライブラリ読込
;*******************************************************************************
#Include Priority_v2.ahk



;*******************************************************************************
; 設定ウィンドウ周り
;*******************************************************************************
;===============================================================================
; 設定ウィンドウ 初期化
;===============================================================================
MainWindowInit() {
	;---------------------------------------
	; コントロールサイズ定数
	;---------------------------------------
	GUI_CONTROL_WIDTH			:= 150
	GUI_CONTROL_WIDTH_CLASS		:= 250
	GUI_CONTROL_WIDTH_LINE		:= 730
	GUI_CONTROL_HIGHT_LABEL		:= 20
	GUI_CONTROL_HIGHT_BUTTON	:= 25

	;---------------------------------------
	; 変数
	;---------------------------------------
	ctrl_options	:= ""		;コントロールオプション

	;---------------------------------------
	; メインウィンドウを作成
	;---------------------------------------
	GuiObj	:=	Gui( "+LastFound"
					, APP_WINDOWTITLE)

	GuiObj.OnEvent( "Close", Exit)

	;---------------------------------------
	; プロセス優先度切替
	;---------------------------------------
	;タイトル行
	ctrl_option	:=	  "xm"
		. Chr(32)	. "ym"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_LABEL
	GuiObj	.Add( "Text", ctrl_option, "プロセス優先度")

	;現状表示
	ctrl_option	:=	  "xp+0"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_BUTTON
		. Chr(32)	. "ReadOnly"
	GuiObj	.Add( "Edit", ctrl_option . " vCtrlEdit_Priority")

	;切替用ボタン
	ctrl_option	:=	  "xp+0"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_BUTTON
	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_Priority_24"	, "リアルタイム")
				.OnEvent( "Click", PriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_Priority_13"	, "高")
				.OnEvent( "Click", PriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_Priority_10"	, "通常以上")
				.OnEvent( "Click", PriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_Priority_8"		, "通常")
				.OnEvent( "Click", PriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_Priority_6"		, "通常以下")
				.OnEvent( "Click", PriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_Priority_4"		, "低")
				.OnEvent( "Click", PriorityUpdate)

	;---------------------------------------
	; プロセスI/O優先度切替
	;---------------------------------------
	;タイトル行
	ctrl_option	:=	  "x+10"
		. Chr(32)	. "ym"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_LABEL
	GuiObj	.Add( "Text", ctrl_option, "プロセスI/O優先度")

	;現状表示
	ctrl_option	:=	  "xp+0"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_BUTTON
		. Chr(32)	. "ReadOnly"
	GuiObj	.Add( "Edit", ctrl_option . " vCtrlEdit_IoPriority")

	;切替用ボタン
	ctrl_option	:=	  "xp+0"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_BUTTON
	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_IoPriority_2"	, "通常")
				.OnEvent( "Click", IoPriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_IoPriority_1"	, "低")
				.OnEvent( "Click", IoPriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_IoPriority_0"	, "特低")
				.OnEvent( "Click", IoPriorityUpdate)

	;---------------------------------------
	; プロセスメモリ優先度切替
	;---------------------------------------
	;タイトル行
	ctrl_option	:=	  "x+10"
		. Chr(32)	. "ym"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_LABEL
	GuiObj	.Add( "Text", ctrl_option, "プロセスメモリ優先度")

	;現状表示
	ctrl_option	:=	  "xp+0"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_BUTTON
		. Chr(32)	. "ReadOnly"
	GuiObj	.Add( "Edit", ctrl_option . " vCtrlEdit_MemoryPriority")

	;切替用ボタン
	ctrl_option	:=	  "xp+0"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_BUTTON
	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_MemoryPriority_5"	, "通常")
				.OnEvent( "Click", MemoryPriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_MemoryPriority_4"	, "通常以下")
				.OnEvent( "Click", MemoryPriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_MemoryPriority_3"	, "中")
				.OnEvent( "Click", MemoryPriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_MemoryPriority_2"	, "低")
				.OnEvent( "Click", MemoryPriorityUpdate)

	GuiObj	.Add( "Button", ctrl_option . " vCtrlButton_MemoryPriority_1"	, "特低")
				.OnEvent( "Click", MemoryPriorityUpdate)

	;--------------------------------------------------------------------------
	; バックグラウンド切替
	;--------------------------------------------------------------------------
	ctrl_option	:=	  "x+10"
		. Chr(32)	. "ym"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_LABEL
	GuiObj	.Add( "Text", ctrl_option, "バックグラウンド切替")

	ctrl_option	:=	  "xp+0"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_BUTTON
	GuiObj	.Add( "Text", ctrl_option)

	ctrl_option	:=	  "xp+0"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_BUTTON
	GuiObj	.Add( "Button", ctrl_option	, "バックグラウンド開始")
				.OnEvent( "Click", BackgroundModeBegin)

	GuiObj	.Add( "Button", ctrl_option , "バックグラウンド終了")
				.OnEvent( "Click", BackgroundModeEnd)

	;--------------------------------------------------------------------------
	; プロセス情報表示
	;--------------------------------------------------------------------------
	ctrl_option	:=	  "xm"
		. Chr(32)	. "ym+200"
		. Chr(32)	. "w"	. GUI_CONTROL_WIDTH_LINE
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_LABEL
	GuiObj	.Add( "Text", ctrl_option
				, "---------------------------------------------------------------------------------------------------------------------------------")

	ctrl_option	:=	  "xm"
		. Chr(32)	. "y+0"
		. Chr(32)	. "w200"
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_LABEL
	GuiObj	.Add( "Text", ctrl_option
				, "アプリケーションウィンドウハンドル")

	ctrl_option	:=	  "x+0"
		. Chr(32)	. "yp+0"
		. Chr(32)	. "w80"
		. Chr(32)	. "h"	. GUI_CONTROL_HIGHT_LABEL
		. Chr(32)	. "ReadOnly"
	GuiObj	.Add( "Edit", ctrl_option . " vCtrlEdit_hWnd", Format( "0x{:x}" , GuiObj.Hwnd))

	;---------------------------------------
	; ウィンドウ表示
	;---------------------------------------
	GuiObj	.Show()

	Return GuiObj.Hwnd
}



;*******************************************************************************
; 優先度制御
;*******************************************************************************
;-------------------------------------------------------------------------------
; CPU優先度設定
;-------------------------------------------------------------------------------
PriorityUpdate( GuiCtrlObj, Info) {
	priority_new := StrReplace( GuiCtrlObj.Name, "CtrlButton_Priority_")
	SetProcessPriority( priority_new)
	Return
}


;-------------------------------------------------------------------------------
; I/O優先度設定
;-------------------------------------------------------------------------------
IoPriorityUpdate( GuiCtrlObj, Info) {
	io_priority_new := StrReplace( GuiCtrlObj.Name, "CtrlButton_IoPriority_")
	SetProcessIoPriority( io_priority_new)
	Return
}


;-------------------------------------------------------------------------------
; メモリ優先度設定
;-------------------------------------------------------------------------------
MemoryPriorityUpdate( GuiCtrlObj, Info) {
	memory_priority_new := StrReplace( GuiCtrlObj.Name, "CtrlButton_MemoryPriority_")
	SetProcessMemoryPriority( memory_priority_new)
	Return
}


;-------------------------------------------------------------------------------
; バックグラウンド開始
;-------------------------------------------------------------------------------
BackgroundModeBegin( GuiCtrlObj, Info) {
	ProcessModeBackgroundBegin()
	Return
}


;-------------------------------------------------------------------------------
; バックグラウンド終了
;-------------------------------------------------------------------------------
BackgroundModeEnd( GuiCtrlObj, Info) {
	ProcessModeBackgroundEnd()
	Return
}


;-------------------------------------------------------------------------------
; ステータス取得・更新
;-------------------------------------------------------------------------------
UpdateStates() {
	GuiFromHwnd( hMainWindow).__Item["CtrlEdit_Priority"]		.Text := GetProcessPriority()
	GuiFromHwnd( hMainWindow).__Item["CtrlEdit_IoPriority"]		.Text := GetProcessIoPriority()
	GuiFromHwnd( hMainWindow).__Item["CtrlEdit_MemoryPriority"]	.Text := GetProcessMemoryPriority()
	Return
}
