﻿;*******************************************************************************
;	Title	標準出力取得ライブラリ
;	Author	NightWork
;	Ver		20251002
;
;-------------------------------------------------------------------------------
;	外部プログラムを実行し、標準出力を得る
;	参考	https://www.autohotkey.com/board/topic/54559-stdin/#entry687172
;
;*******************************************************************************


;*******************************************************************************
;	外部プログラムを実行し、標準出力を得る
;*******************************************************************************
;===============================================================================
;	引数	psCmd			実行するコマンドライン
;			psInput			標準入力へ与える文字列
;			psEncoding		コードページ
;			psDir			外部プロクラムの起動ディレクトリ
;			pnExitCode		終了コードを返す変数
;
;-------------------------------------------------------------------------------
;	返り値	外部プロクラムの標準出力の内容
;
;-------------------------------------------------------------------------------
;	備考	外部プロクラムを実行中のスクリプトと同じCPU優先度で起動するように変更
;
;===============================================================================
StdoutToVar( psCmd, psInput:="", psEncoding:="CP0", psDir:="", ByRef pnExitCode:=0) {
	;パイプ作成
	DllCall( "CreatePipe"			, "PtrP", hStdInRd		, "PtrP", hStdInWr	, "Ptr"	, 0		, "UInt", 0)
	DllCall( "CreatePipe"			, "PtrP", hStdOutRd		, "PtrP", hStdOutWr	, "Ptr"	, 0		, "UInt", 0)
	DllCall( "SetHandleInformation"	, "Ptr"	, hStdInRd		, "Uint", 1			, "Uint", 1)
	DllCall( "SetHandleInformation"	, "Ptr"	, hStdOutWr		, "UInt", 1			, "UInt", 1)

	;PROCESS_INFORMATION構造体
	VarSetCapacity( pi, ( A_PtrSize == 4) ? 16 : 24, 0)

	;STARTUPINFO構造体
	siSz := VarSetCapacity( si, ( A_PtrSize == 4) ? 68 : 104, 0)
	NumPut( siSz		, si	, 0, "UInt")
	NumPut( 0x100		, si	, ( A_PtrSize == 4) ? 44 : 60, "UInt")
	NumPut( hStdInRd	, si	, ( A_PtrSize == 4) ? 56 : 80, "Ptr")
	NumPut( hStdOutWr	, si	, ( A_PtrSize == 4) ? 60 : 88, "Ptr")
	NumPut( hStdOutWr	, si	, ( A_PtrSize == 4) ? 64 : 96, "Ptr")

	;---------------------------------------
	;外部プログラム実行
	If ( !DllCall( "CreateProcess"
			, "Ptr"		, 0																					;Module name
			, "Ptr"		, &psCmd																			;Command line
			, "Ptr"		, 0																					;Process handle
			, "Ptr"		, 0																					;Thread handle not inheritable
			, "Int"		, True																				;Set handle inheritance to FALSE
			, "UInt"	, 0x08000000																		;Creation flags
						| DllCall( "GetPriorityClass", Uint, DllCall( "GetCurrentProcess"))
			, "Ptr"		, 0																					;Use parent's environment block
			, "Ptr"		, psDir ? &psDir : 0																;Use parent's starting directory
			, "Ptr"		, &si																				;Pointer to STARTUPINFO structure
			, "Ptr"		, &pi))																				;Pointer to PROCESS_INFORMATION structure
	{
		DllCall( "CloseHandle"	, "Ptr"	, hStdOutWr)
		DllCall( "CloseHandle"	, "Ptr"	, hStdOutRd)
		DllCall( "CloseHandle"	, "Ptr"	, hStdInRd)
		Return
	}

	DllCall( "CloseHandle"	, "Ptr"	, hStdOutWr) ; The write pipe must be closed before reading the stdout.

	;---------------------------------------
	;標準入力へ与える文字列がある場合送信する
	if ( psInput != "")
		FileOpen( hStdInWr, "h", psEncoding).Write( psInput)
	DllCall( "CloseHandle", "Ptr", hStdInWr)

	;---------------------------------------
	;外部プログラムの標準出力を得る
	StdOutBuf := FileOpen( hStdOutRd, "h", psEncoding)
	StrBuf := 1

	While StrLen( StrBuf) {
		StrBuf := StdOutBuf.Read( 2047)
		sOutPut .= StrBuf
	}

	;---------------------------------------
	;後始末
	DllCall( "GetExitCodeProcess"	, "Ptr"	, NumGet( pi, 0, "UInt")	, "UIntP", pnExitCode)
	DllCall( "CloseHandle"			, "Ptr"	, NumGet( pi, 0, "UInt"))
	DllCall( "CloseHandle"			, "Ptr"	, NumGet( pi, A_PtrSize	, "UInt"))
	DllCall( "CloseHandle"			, "Ptr"	, hStdOutRd)

	Return sOutput
}
